#! /usr/bin/perl 
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# "@(#)27   1.10   src/hmcpok/exp_restrict/hps_check.pl, fnm, hmcpok_rel3, rel3s011e 8/24/04 12:33:18"
#
# Author: Nathan Besaw
#
# Change History
# 
# V1.13 08.18.2004
#       Removed dots signifying waiting time and added statements
#       instead to inform user of progress.  (Jenn Martin)
#
# V1.12 06.21.2004
#	Added a new option "--svcnet" that can be used to take
#	a snapshot of the available CSP and BPA hardware categorized by
#	owning HMC.  This option is intended to be a quick service network
#	status sanity check.
#
# V1.11 05.07.2004
# 	Decreased the number of commands per block.
#
# V1.10	02.10.2004
#	Added pacing to commands to scale on large systems.
#	Fixed a bug that prevented lpar names from printing.
#	Modified the path to fnm_test.
#
# V1.09 01.05.2004
#	Added SRX-1 and SRX-2 UID to Cage mapping.
#
# V1.08 10.01.2003
#	Added duplicate vport checking.
#
# V1.07 9.22.2003
#	Added Cage number gathering to the output.
#
# V1.06 8.28.2003
#	Suppress reporting about adapters that aren't present. 
#
# V1.05	8.5.2003
# 	Added switch neighbor information
#
# V1.04	6.12.2003
#	Fixed a problem with LPAR/SNI => Adapter Mapping.
#	Added --local flag to query only local hardware.
#	Added --vport flag to query a specific vport.
#
# V1.03 6.2.2003
#	Added a check to only do scom reads to functional adapters.
#
# V1.02 5.30.2003
#	Check the current directory for fnm_test, if that 
#	fails, look to the tools directory.
#
# V1.01	5.29.2003	
#	Added support for mapping lpar/SNI pairs to adapter.
#	Added support for turning on debug printing.
#	Removed one of the TOD register reads and replaced it with
#	a read of the 0x21040 register.
#	Added some visual feedback for the user during long waits.
#	
# V1.0 	5.15.2003 
#	Original Version

if(stat("/opt/hsc/bin/fnm_test"))
{
        $fnm_test = "/opt/hsc/bin/fnm_test";
}
else
{
        $fnm_test = "/usr/local/hsctool/fnm_test";
}

use Class::Struct;
use Sys::Hostname;
use Getopt::Long;
use Socket;

# Forward declare subroutines
sub get_csp_vports;
sub get_ipl_ready_vports;
sub get_registers;
sub get_functional_adapters;
sub get_hmc_addresses;
sub get_hmc_vports;
sub get_vport_info;


# Records used for displaying service network information
struct ServiceNetworkHmc =>
{
	global_vport => '$',
	ip_address => '$',
	ip_string => '$',
	hostname => '$',
	csp_records => '%',
	bpa_records => '%'
};

struct ServiceNetworkCsp =>
{
	vport => '$',
	cec_name => '$',
	mtms => '$',
	frame_number => '$'
};

struct ServiceNetworkBpa =>
{
	vport => '$',
	mtms => '$',
	frame_number => '$'
};

struct LparMapRecord =>
{
	lpar_id => '$',
	csp_numbers => '@'
};

struct VportRecord =>
{
	vport => '$',					# "fffffe03"
	vport2 => '$',					# "fffffe06"
	frame => '$',					# Frame number
	cage => '$',					# Cage number
	op_panel => '$',				# "LPAR..."
	cec_state => '$',				# "01"
	cec_summary => '$',				# "This CEC is IPL_READY."
	cec_name => '$',				# "c409<f1>c406"
	cec_mtms => '$',				# "7040-681*1234567"
	hmc_reg => '$',					# "3eff"
	fnm_reg => '$',					# "100"
	poll_freq => '$',				# "0078"
	hmc_conn => '$',				# "01"
	p => '@',					# SMA present? -, Y, or N
	f => '@',					# SMA functional? -, Y, or N
	timing => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x24030
	mp_avail => '@',				# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x6050
	t_one => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x20000
	t_two => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x20000
	t_gen => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21030
	t_mast => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21000
	who_mast => '@',				# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21040
	t_back => '@',					# [0, 0, 0, 0, 0, 0, 0, 0] Reg 0x21010
	phys_id => '@',					# Reg 0x2B000
	sloc => '@',					# Switch Neighbor Location Reg 0x23020
	nid => '@',					# Network Id
	eid => '@',					# Endpoint Id
	nf => '@',					# Neighbor Frame
	nca => '@',					# Neighbor Cage
	nch => '@',					# Neighbor Chip
	np => '@',					# Neighbor Port
	lpar_map => '%',				# Map of Lpar/SNI to Adapter Number
	timed => '@',					# Is this Adapter timed (Y/N)
	mp => '@',					# What is the Adapter MP Available status (N/Y/F)
	tod => '@',					# What is the TOD identity (M/B/S)
	num_lpars => '$',				# The number of lpars available on this CEC
	lpar_names => '@'				# What are the lpar names for this CEC?
};

# A hash for mapping adapter chip into adapter number
%csp_to_adapter =
(	
	2 => 0,
	3 => 1,
	6 => 2,
	7 => 3,
	8 => 4,
	9 => 5,
	12 => 6,
	13 => 7
);

%csp_to_cronus =
(
	2 => 5,
	3 => 4,
	6 => 13,
	7 => 12,
	8 => 6,
	9 => 7,
	12 => 14,
	13 => 15	
);

# Declare formats used for reports later.
# A CEC record.
format HEADING =
--------------------------------------------------------------------------------------------------------------
VPORT 1:      @>>>>>>>  CEC_NAME: @<<<<<<<<<<<<<<<<<<<<<<<<   CEC_MTMS:  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$v->vport(), $v->cec_name(), $v->cec_mtms(),
VPORT 2:      @>>>>>>>  HMC_REG:  @>>>  POLL_FREQ: @>>>       CEC_STATE: (@<) @<<<<<<<<<<<<<<<<<<<<<<< 
$v->vport2(), $v->hmc_reg(), $v->poll_freq(), $v->cec_state(), $v->cec_summary()
FRAME:  @>>>  CAGE: @>  FNM_REG:  @>>>  HMC_CONN:  @>>>       OP_PANEL:  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$v->frame(), $v->cage(), $v->fnm_reg(), $v->hmc_conn(), $v->op_panel()

.

# The header for the lpar/sni mapping	
format LPAR_HEADER = 
SNI Mapping:                                                        Switch Neighbor:
Lpar Name                  Lpar# Sni# => Adapter#  Csp#  Cronus# => Frame Cage Chip Port : Timed?  MPA  TOD
.

# The lpar/sni mapping
format LPAR_MAP =
@<<<<<<<<<<<<<<<<<<<<<<<<< @>>>> @>>>    @>>>>>>>  @>>>  @>>>>>>     @>>> @>>> @>>> @>>>   @>>>>>  @>>  @>>
$lpar_name,$lpar->lpar_id(),$sni_count,$csp_to_adapter{$csp_number},$csp_number,$csp_to_cronus{$csp_number},$nf,$nca,$nch,$np,$timed,$mp,$tod
.

# The detail data format
format DETAIL1_HDR = 
Mapping:                Neighbor:        Summary:       Registers:                                                         
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  TIMED     0x24030  MP_AVAIL   0x6050  TOD       0x20000
.

format DETAIL1 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->timing($q),$v->mp_avail($q),$v->t_one($q)
.

format DETAIL2_HDR =
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  PHYS_ID   0x2B000  NEIGH_ID  0x23020  WHO_MAST  0x21040
.

format DETAIL2 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->phys_id($q),$v->sloc($q),$v->who_mast($q)
.

format DETAIL3_HDR =
PF Adp Csp Crn Net Endp Fram Cag Chp Prt Timed MPA TOD  TOD_GEN   0x21030  TOD_MAST  0x21000  TOD_BACK  0x21010
.

format DETAIL3 = 
@@  @>  @>  @>   @ @>>> @>>> @>> @>> @>> @>>>> @>> @>>  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<
$v->p($q),$v->f($q),$Adp,$Csp,$Crn,$v->nid($q),$v->eid($q),$v->nf($q),$v->nca($q),$v->nch($q),$v->np($q),$v->timed($q),$v->mp($q),$v->tod($q),$v->t_gen($q),$v->t_mast($q),$v->t_back($q)
.

format SERVICE_HEADER =
HMC Name       HMC IP Address  Type  Frame     Vport              MTMS             CEC Name 
.

format SERVICE_CSP =
@<<<<<<<<<<<  @>>>>>>>>>>>>>>   CSP  @>>>>  @>>>>>>>  @>>>>>>>>>>>>>>>  @>>>>>>>>>>>>>>>>>>>  
$h->hostname(), $h->ip_string(), $c->frame_number(), $c->vport(), $c->mtms(), $c->cec_name()
.

format SERVICE_BPA =
@<<<<<<<<<<<  @>>>>>>>>>>>>>>   BPC  @>>>>  @>>>>>>>  @>>>>>>>>>>>>>>>  
$h->hostname(), $h->ip_string(), $b->frame_number(), $b->vport(), $b->mtms()
.

format SERVICE_NO_HARDWARE =
@<<<<<<<<<<<  @>>>>>>>>>>>>>>  NONE  
$h->hostname(), $h->ip_string(), 
.

# Get the commandline options
GetOptions
( 
	"debug" => \$debug, 
	"local" => \$local_mode,
	"vport=s" => \$single_vport,
	"svcnet" => \$network_status
);

# Set stdout to autoflush if debug isn't enabled.
if($debug == 0)
{
	#print {STDOUT} "Setting autoflush.\n";
	$old_stdout = select(STDOUT);
	$| = 1;
	select($old_stdout);
}

# Some variables used to let the user know that things are running.
$line_count = 0;
$lines_per_dot = 20;
$dots_before_break = 80;

print {STDOUT} "Gathering data, please wait.\n";

# Should we run the network status gathering utility?
if(defined $network_status)
{
	# Get the list of HMC IP addresses
	print {STDOUT} "Getting HMC addresses now. \n";
	get_hmc_addresses;

	# Get the list of HMC vports for each HMC in the list
	print {STDOUT} "Getting HMC vports now. \n";
	get_hmc_vports;

	# Get identifying information for each vport
	print {STDOUT} "Getting vport information now. \n";
	get_vport_info;

	print {STDOUT} "\n\n";

	$bpa_total = 0;
	$frame_total = 0;
	$csp_total = 0;
	$server_total = 0;
	$hmc_total = 0;
	$active_hmc_total = 0;
	%server_hash;
	%frame_hash;
	
	foreach $h (sort {hex $a->ip_address() <=> hex $b->ip_address()} values %hmc_records)
	{
		$bpa_subtotal = 0;
		$csp_subtotal = 0;
	
		# Write the header		
		$~ = "SERVICE_HEADER";
		write;

		$csp_vport_hash_ref = $h->csp_records; 

		foreach $c (sort {hex $a->frame_number() <=> hex $b->frame_number()} values %$csp_vport_hash_ref)
		{

			$~ = "SERVICE_CSP";
			write;
			
			# Check to see if this is a redundant path
			if(!(exists $server_hash{$c->mtms()}))
			{
				$server_hash{$c->mtms()} = $c->mtms();
				$server_total++;
			}

			$csp_subtotal++; 
		}
		
		$bpa_vport_hash_ref = $h->bpa_records; 

		foreach $b (sort {hex $a->frame_number() <=> hex $b->frame_number()} values %$bpa_vport_hash_ref)
		{
			$~ = "SERVICE_BPA";
			write;
			
			# Check to see if this is a redundant path
			if(!(exists $frame_hash{$b->mtms()}))
			{
				$frame_hash{$b->mtms()} = $b->mtms();
				$frame_total++;
			}

			$bpa_subtotal++; 
		}

		if((keys %$bpa_vport_hash_ref == 0) && (keys %$csp_vport_has_ref == 0))
		{
			$~ = "SERVICE_NO_HARDWARE";
			write;
		}

		$bpa_total += $bpa_subtotal;
		$csp_total += $csp_subtotal;

		$hmc_total++;

		if(($bpa_subtotal > 0) || ($csp_subtotal >0))
		{
			$active_hmc_total++;
		}

		printf ("\n SUBTOTAL:  HMC %s(%s) has %d server connections and %d frame connections.\n",
			$h->ip_string(), $h->hostname(), $csp_subtotal, $bpa_subtotal); 
		print {STDOUT} "\n";
	}

	# Write the totals
	printf ("SERVER TOTAL: %d connections to %d servers.\n", $csp_total, $server_total); 
	printf ("FRAME TOTAL:  %d connections to %d frames.\n", $bpa_total, $frame_total);
	printf ("HMC TOTAL:    %d/%d HMCs have working connections.\n", $active_hmc_total, $hmc_total); 
	print {STDOUT} "\n";	

	$date = localtime(time());
	$host = hostname();

	print { STDOUT } "\nThis snap was generated $date on $host.\n";
	exit;
}

# Get the list of CSP vports.
print {STDOUT} "Getting CSP vports now. \n";
get_csp_vports;

#print { STDOUT } "After get_csp_vports.\n";

# Get the CEC NAME, MTMS, and STATE
print {STDOUT} "Getting IPL ready vports now. \n";
get_ipl_ready_vports;

#print { STDOUT } "After get_ipl_ready_vports.\n";

# Get the SMA LINK INFO for each CEC
print {STDOUT} "Getting functional adapters now. \n";
get_functional_adapters;

# Get the SCOM registers for all CECs that are IPL_READY
print {STDOUT} "Getting registers now. \n";
get_registers;

print {STDOUT} "\n\n";

# Print all records
foreach $v (sort { $a->vport() <=> $b->vport() } values %vport_records)
{
	$~ = "HEADING";
	write;
	
	$lpar_hash_ref = $v->lpar_map;
	$lpar_header_printed = "NO";
	$detail_header_1_printed = "NO";
	$detail_header_2_printed = "NO";
	$detail_header_3_printed = "NO";

	foreach $lpar (sort { $a->lpar_id() <=> $b->lpar_id() } values %$lpar_hash_ref)
	{
		#print { STDOUT } "Inside foreach $lpar, LPAR.";
		
		if($lpar_header_printed eq "NO")
		{
			$lpar_header_printed = "YES";
			$~ = "LPAR_HEADER";
			write;
		}

		$lpar_id = $lpar->lpar_id();
		#print { STDOUT } "Inside foreach $lpar, LPAR = $lpar_id.";

		$csp_numbers_list_ref = $lpar->csp_numbers;

		$sni_count = 0;
		foreach $csp_number (sort { $a <=> $b } @$csp_numbers_list_ref)
		{
			$lpar_name = $v->lpar_names($lpar->lpar_id());
			$timed = $v->timed($csp_to_adapter{$csp_number});
			$mp = $v->mp($csp_to_adapter{$csp_number});
			$tod = $v->tod($csp_to_adapter{$csp_number});
			$nf = $v->nf($csp_to_adapter{$csp_number});
			$nca = $v->nca($csp_to_adapter{$csp_number});
			$nch = $v->nch($csp_to_adapter{$csp_number});
			$np = $v->np($csp_to_adapter{$csp_number});

			$~ = "LPAR_MAP";
			write;

			$sni_count++;
		}
	}

	if($lpar_header_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
    

	# Print the first section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_1_printed eq "NO")
			{
				$detail_header_1_printed = "YES";
				$~ = "DETAIL1_HDR";
				write;
			}

		
			$~ = "DETAIL1";
			write;
		}
	
	}
	
	if($detail_header_1_printed eq "YES")
	{
		print {STDOUT} "\n";
	}

	# Print the second section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_2_printed eq "NO")
			{
				$detail_header_2_printed = "YES";
				$~ = "DETAIL2_HDR";
				write;
			}

		
			$~ = "DETAIL2";
			write;
		}
	
	}
	
	if($detail_header_2_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
	
	# Print the third section of adapter details
	for($q = 0; $q < 8; $q++)
	{
		if($q == 0) 	{$Adp = 0;	$Csp = 2;	$Crn = 5;}
		elsif($q == 1)	{$Adp = 1;	$Csp = 3;	$Crn = 4;}	
		elsif($q == 2)	{$Adp = 2;	$Csp = 6;	$Crn = 13;}	
		elsif($q == 3)	{$Adp = 3;	$Csp = 7;	$Crn = 12;}	
		elsif($q == 4)	{$Adp = 4;	$Csp = 8;	$Crn = 6;}	
		elsif($q == 5)	{$Adp = 5;	$Csp = 9;	$Crn = 7;}	
		elsif($q == 6)	{$Adp = 6;	$Csp = 12;	$Crn = 14;}	
		elsif($q == 7)	{$Adp = 7;	$Csp = 13;	$Crn = 15;}	

		# Check to see if this adapter is present
		if($v->p($q) eq "Y")
		{
			if($detail_header_3_printed eq "NO")
			{
				$detail_header_3_printed = "YES";
				$~ = "DETAIL3_HDR";
				write;
			}

		
			$~ = "DETAIL3";
			write;
		}
	
	}
	
	if($detail_header_3_printed eq "YES")
	{
		print {STDOUT} "\n";
	}
}

$date = localtime(time());
$host = hostname();

print { STDOUT } "\nThis snap was generated $date on $host.\n";

sub get_csp_vports 
{
	if(defined $single_vport)
	{
		open(FH, "echo \"VPORT LIST $single_vport\" | ") or die("Failed to open fnm_test.");
	}
	else
	{
		if($local_mode != 0)
		{
			open(FH, "$fnm_test -s \"qlc\" | ") or die("Failed to open fnm_test.");
		}
		else
		{
			open(FH, "$fnm_test -s \"qgc\" | ") or die("Failed to open fnm_test.");	
		}
	}

	my $vport_record;

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{	
			print {STDOUT} "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} "";
				# print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "";
				# print {STDOUT} "\n";
			}
		}	

		if(/VPORT LIST/)
		{
			$count = 0;
			while(/([0123456789abcdef]+)/g)
			{
				$vport_record = VportRecord->new();

				$vport_record->vport($1);
				$vport_record->vport2("--------");
				$vport_record->frame("----");	
				$vport_record->cage("--");	
				$vport_record->op_panel("N/A");
				$vport_record->cec_name("N/A");
				$vport_record->cec_mtms("N/A");
				$vport_record->cec_state("--");
				$vport_record->cec_summary("N/A");
				$vport_record->hmc_reg("N/A");
				$vport_record->fnm_reg("N/A");
				$vport_record->poll_freq("N/A");
				$vport_record->hmc_conn("N/A");
				$vport_record->num_lpars(0);

				for($count = 0; $count < 8; $count++)
				{
					$vport_record->p($count, '-');
					$vport_record->f($count, '-');
					$vport_record->timing($count, '-------- --------');
					$vport_record->mp_avail($count, '-------- --------');
					$vport_record->t_one($count, '-------- --------');
					$vport_record->t_two($count, '-------- --------');
					$vport_record->t_gen($count, '-------- --------');
					$vport_record->t_mast($count, '-------- --------');
					$vport_record->who_mast($count, '-------- --------');
					$vport_record->t_back($count, '-------- --------');
					$vport_record->phys_id($count, '-------- --------');
					$vport_record->sloc($count, '-------- --------');
					$vport_record->nid($count, '-');
					$vport_record->eid($count, '-');	
					$vport_record->nf($count, '-');	
					$vport_record->nca($count, '-');	
					$vport_record->nch($count, '-');	
					$vport_record->np($count, '-');	
					$vport_record->timed($count, '-');	
					$vport_record->mp($count, '-');	
					$vport_record->tod($count, '-');	
				}

				$vport_records{ $vport_record->vport() } = $vport_record; 

				#print { STDOUT } "$csp_vports[$count] ";
				$count++;
			}
		}
	}
			
	#print { STDOUT } "\n";
	close(FH);
	#return @csp_vports;
}

sub get_ipl_ready_vports
{
	my @command_string;
	my $record_count = 0;
	my $command_count = 0;
	my $current_vport = "";
	my $cs_index = 0;
	my $cs_max = 0;
	my $commands_per_block = 2400;

	$command_string[0] = "";

	# Build a string to query the state of all CECs in the system.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{

		# Select the next virtual port
		$command_string[$cs_index] .= "sv " . $vport_record->vport() . "\n";
	
		# Get the CEC state
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 05\n";
	
		# Get the Op Panel Value
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 0c\n";	

		# Get the HMC registration
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 16\n";

		# Get the FNM registration
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 46\n";

		# Get the Polling Frequency
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 23\n";

		# Get the CEC name
		$command_string[$cs_index] .= "cn\n";
		
		# Get the CEC MTMS
		$command_string[$cs_index] .= "cm\n";

		# Get the Frame number
		$command_string[$cs_index] .= "cgf\n";
		
		# Get the Cage number
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 01 04\n";
	
		# Get the number of lpars
		$command_string[$cs_index] .= "cd 80 00 00 00 00 01 02 13\n";
	
		$command_count += 11;

		# Break up the commands into blocks, to scale on large systems
		if($command_count / $commands_per_block >= 1)
		{
			$cs_index++;
			$cs_max++;
			$command_string[$cs_index] = "";
			$command_count = 0;
		}
		
		$record_count++;
	}
	
	if( $record_count == 0 )
	{
		return;
	}

	if( $command_string[$cs_max] eq "" )
	{
		$cs_max--;
	}

	$record_count = 0;

	for($cs_index = 0; $cs_index <= $cs_max; $cs_index++)
	{
		#print { STDOUT } "$cs_index:$cs_max $command_string[$cs_index]\n";
		
		open(FH, "$fnm_test -s \"$command_string[$cs_index]\" |") or die("Failed to open fnm_test.");

		while(<FH>)
		{
			chomp;
	
			if($debug)
			{
				print { STDOUT } "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} ".";
				}

				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} "\n";
				}
			}	

			if(/VPORT/)
			{
				if(/([0123456789abcdef]{8})/)
				{
					# Grab the vport for this packet. 
					$current_vport = $1;
					#print { STDOUT } "$1 ";
				}
			}

			my $state = "";
			my $string = "";
	
			if(/PAYLOAD HEX/)
			{
				my $count = 0;
				my $last = 0;
				while(/([0123456789abcdef]{2})/g)
				{
					# Check to see if this vport is IPL_READY
					
					if($count == 7)
					{
						if($1 eq "02")
						{
							if($last eq "01")
							{
								$state = "CEC_NAME";
							}
							else
							{
								$state = "FRAME";
							}
						}
						elsif($1 eq "03")
						{
							$state = "CEC_MTMS";
						}
						elsif($1 eq "04")
						{
							$state = "CAGE";
						}
						elsif($1 eq "05")
						{
							$state = "CEC_STATE";
						} 		
						elsif($1 eq "0c")
						{
							$state = "OP_PANEL"
						}
						elsif($1 eq "13")
						{
							$state = "NUM_LPARS"
						}
						elsif($1 eq "16")
						{
							$state = "HMC_REG"
						}
						elsif($1 eq "23")
						{
							$state = "POLL_FREQ"
						}
						elsif($1 eq "46")
						{
							$state = "FNM_REG"
						}
					}
	
					if( ( $state eq "CEC_NAME" ) || 
				  	    ( $state eq "CEC_MTMS" ) ||
					    ( $state eq "CAGE") ) 
					{
						if($count >= 8)
						{
							$string .= chr(hex($1));
						}
					}
					elsif( $state eq "OP_PANEL" )
					{
						if($count >= 10)
						{
							$string .= chr(hex($1));
						}
					}
					elsif( $state eq "CEC_STATE" )
					{
						if($count == 8)
						{
							# Save the CEC state.
							$vport_records{$current_vport}->cec_state($1);
	
							if($1 == "01")
							{
								# This is an IPL_READY vport.
								$vport_records{$current_vport}->cec_summary(
									"CEC is IPL_READY.");
							}
							else
							{
								# This is not an IPL_READY vport.
								$vport_records{$current_vport}->cec_summary(
									"CEC is not IPL_READY.");
							}
						}
					}		
					elsif( ( $state eq "HMC_REG" ) ||
					       ( $state eq "FNM_REG" ) ||
					       ( $state eq "POLL_FREQ") ||
					       ( $state eq "FRAME" ) ||
					       ( $state eq "NUM_LPARS") ) 
					{
						if($count >= 8)
						{
							$string .= $1;
						}
					}
					$count++;
					$last = $1;
				}
			}
	
			if( $state eq "CEC_NAME" )
			{
				# Save the CEC_NAME string.
				$vport_records{$current_vport}->cec_name($string);
			}
			
			if( $state eq "CEC_MTMS" )
			{
				# Save the CEC_MTMS string.
				$vport_records{$current_vport}->cec_mtms($string);
			}
	
			if( $state eq "OP_PANEL" )
			{
				# Save the OP_PANEL string.
				$vport_records{$current_vport}->op_panel($string);	
			}

			if( $state eq "HMC_REG" )
			{
				$vport_records{$current_vport}->hmc_reg(substr($string, 4, 4));
			}
	
			if( $state eq "FNM_REG" )
			{
				$vport_records{$current_vport}->fnm_reg(substr($string, 4, 4));
			}
			
			if( $state eq "POLL_FREQ" )
			{
				$vport_records{$current_vport}->poll_freq((hex(substr($string, 0, 4))));
				$vport_records{$current_vport}->hmc_conn(substr($string, 6, 2));
			}
			
			if( $state eq "FRAME" )
			{
				$vport_records{$current_vport}->frame((hex(substr($string, 0, 4))));	
			}

			if( $state eq "CAGE" )
			{
			        $uid = 0;
               		        $cage = 0;

				if(substr($string, 2, 1) eq '.')
				{
					$uid = substr($string, 3, 2);
				}
				else
				{
					$uid = 255;
				}	
	
				if( ( substr($vport_records{$current_vport}->cec_mtms(), 0, 8) eq "6A40-100" ) ||
				    ( substr($vport_records{$current_vport}->cec_mtms(), 0, 8) eq "6A40-200" ) )
				{
					# Perform SRX1 Uid to Cage mapping
	                        	# SRX-1 System Specification SR-HI-0032 Rev 0.5
					if($uid == 11)		{       $cage = 2;       }
	                        	elsif($uid == 12)       {       $cage = 1;       }
	                        	elsif($uid == 13)       {       $cage = 6;       }
       		                 	elsif($uid == 14)       {       $cage = 5;       }
       		                 	elsif($uid == 21)       {       $cage = 3;       }
       		                 	elsif($uid == 22)      	{       $cage = 4;       }
       	        	         	elsif($uid == 23)      	{       $cage = 7;       }
               	 	        	elsif($uid == 24)      	{       $cage = 8;       }
                       		 	else			{       $cage = 255;     }
				}
				else
				{
                	        	# Map the IH and H Cec Uid location codes to cage number
                        		if($uid == 1)          {       $cage = 1;       }
                        		elsif($uid == 2)       {       $cage = 2;       }
                        		elsif($uid == 5)       {       $cage = 3;       }
                        		elsif($uid == 6)       {       $cage = 4;       }
                        		elsif($uid == 9)       {       $cage = 5;       }
                        		elsif($uid == 10)      {       $cage = 6;       }
                        		elsif($uid == 13)      {       $cage = 7;       }
                        		elsif($uid == 14)      {       $cage = 8;       }
                        		elsif($uid == 19)      {       $cage = 9;       }
                        		elsif($uid == 20)      {       $cage = 10;      }
                        		elsif($uid == 23)      {       $cage = 11;      }
                        		elsif($uid == 24)      {       $cage = 12;      }
                        		elsif($uid == 27)      {       $cage = 13;      }
                        		elsif($uid == 28)      {       $cage = 14;      }
                        		elsif($uid == 31)      {       $cage = 15;      }
                        		elsif($uid == 32)      {       $cage = 16;      }
                        		elsif($uid == 18)      {       $cage = 0;       }
                        		else                   {       $cage = 255;     }
				}

				$vport_records{$current_vport}->cage($cage);
			}

			if( $state eq "NUM_LPARS" )
			{
				$vport_records{$current_vport}->num_lpars((hex(substr($string, 0, 2))));	
			}
		}	
		close(FH);
	
	}	# End of scaling loop

	# Pair vports that go to the same location, and remove duplicates from the list.
	my %cec_name_hash;

	foreach my $vport_rec (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		# Do we already have a vport to reach this CEC?
		if(exists ($cec_name_hash{$vport_rec->cec_name()}))
		{
			# Add the second vport to the first vport record.	
			$vport_records{$cec_name_hash{$vport_rec->cec_name()}}->vport2($vport_rec->vport());

			# Remove the second vport from the vport_record hash.
			delete($vport_records{$vport_rec->vport()});
		}
		else
		{
			# We need to add this vport to the cec_name_hash
			$cec_name_hash{$vport_rec->cec_name()} = $vport_rec->vport();
		}
	}
}

sub get_functional_adapters
{
	my @command_string;
	my $record_count = 0;
	my $command_count = 0;
	my $current_vport = "";
	my $cs_index = 0;
	my $cs_max = 0;
	my $commands_per_block = 2400;
	
	$command_string[0] = "";

	# Build a string to query which adapters are functional.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		if($vport_record->cec_state() eq "01")
		{
			# This CEC is IPL_READY, we ignore all other states

			# Select the next virtual port
			$command_string[$cs_index] .= "sv " . $vport_record->vport() . "\n";
			
			# Get the SMA Link Info
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 18\n";
			
			$command_count += 2;

			# Break up the commands into blocks, to scale on large systems
			if($command_count / $commands_per_block >= 1)
			{
				$cs_index++;
				$cs_max++;
				$command_string[$cs_index] = "";
				$command_count = 0;
			}

			$record_count++;
		}
	}
	
	if( $record_count == 0 )
	{
		return;
	}
	
	if( $command_string[$cs_max] eq "" )
	{
		$cs_max--;
	}

	$record_count = 0;

	for($cs_index = 0; $cs_index <= $cs_max; $cs_index++)
	{
		#print { STDOUT } "$cs_index:$cs_max $command_string[$cs_index]\n";
		
		open(FH, "$fnm_test -s \"$command_string[$cs_index]\" |") or die("Failed to open fnm_test.");

		my $current_adapter = 0;
		my $scom_address = "";
		my $rc_state = "";
		my $command = "";
		my $lpar_map_index = 0;
		my $present_string = "";
		my $functional_string = "";

		while(<FH>)
		{
			chomp;
	
			if($debug)
			{
				print { STDOUT } "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} ".";
				}
	
				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} "\n";
				}
			}	

			if(/VPORT/)
			{
				if(/([0123456789abcdef]{8})/)
				{
					# Grab the vport for this packet. 
					$current_vport = $1;
					#print { STDOUT } "$1 ";
				}
			}

			if(/PAYLOAD HEX/)
			{
				my $count = 0;
				$present_string = "";
				$functional_string = "";
	
				while(/([0123456789abcdef]{2})/g)
				{
					# Check the status of the adapters
				
					if($count == 4)
					{
						if($1 eq "00")
						{
							$rc_state = "GOOD_RC";
						}
						else
						{
							$rc_state = "BAD_RC";
						} 		
					}
				
					if( ($count >= 8) && ($count <= 11))
					{
						$present_string .= $1;
					}
				
					if( ($count >= 12) && ($count <= 15))
					{
						$functional_string .= $1;
					}

					$count++;
				}
			}
					
			#print {STDOUT} "rc_state equals $rc_state\n";

			if($rc_state eq "GOOD_RC")
			{
				#print {STDOUT} "present_mask equals $present_string\n";
				#print {STDOUT} "functional_mask equals $functional_string\n";
			
				$present_mask = hex($present_string);
				$functional_mask = hex($functional_string);

				# Parse the present and functional masks
				for(my $itr = 0; $itr < 32; $itr++)
				{
					if(($present_mask & 0x80000000) == 0x80000000)
					{
						#print {STDOUT} "$itr is present $present_mask\n";
	
						# There is an SMA present
						if( exists($csp_to_adapter{$itr}) )
						{
							$vport_records{$current_vport}->p($csp_to_adapter{$itr}, "Y");
						}
					}
					else
					{
						#print {STDOUT} "$itr is not present $present_mask\n";
					
						if( exists($csp_to_adapter{$itr}) )
						{
							$vport_records{$current_vport}->p($csp_to_adapter{$itr}, "N");
						}
					}	
				
					if(($functional_mask & 0x80000000) == 0x80000000)
					{
						#print {STDOUT} "$itr is functional $functional_mask\n";
					
						# There is an SMA present
						if( exists($csp_to_adapter{$itr}) )
						{
							$vport_records{$current_vport}->f($csp_to_adapter{$itr}, "Y");
						}
					}
					else
					{
						#print {STDOUT} "$itr is not functional $functional_mask\n";
					
						if( exists($csp_to_adapter{$itr}) )
						{
							$vport_records{$current_vport}->f($csp_to_adapter{$itr}, "N");
						}
					}	

					$present_mask = $present_mask << 1;
					$functional_mask = $functional_mask << 1;
				}
			}
		}

	close(FH);
	
	}	# End of scaling loop
}

sub get_registers
{
	my @command_string;
	my $record_count = 0;
	my $command_count = 0;
	my $current_vport = "";
	my $cs_index = 0;
	my $cs_max = 0;
	my $commands_per_block = 2400;

	$command_string[0] = "";

	# Build a string to query the state of all CECs in the system.
	foreach $vport_record (sort { $a->vport() <=> $b->vport() } values %vport_records)
	{
		if($vport_record->cec_state() eq "01")
		{
			# This CEC is IPL_READY, we ignore all other states

			# Select the next virtual port
			$command_string[$cs_index] .= "sv " . $vport_record->vport() . "\n";
			$command_count++;	

			for($adapter = 0; $adapter < 8; $adapter++)
			{
				if( $vport_record->f($adapter) eq "Y")
				{
					# Get the timing register 0x24030
					$command_string[$cs_index] .= "sr " . $adapter . " 24030 \n";

					# Get the mp available register 0x6050
					$command_string[$cs_index] .= "sr " . $adapter . " 6050 \n";

					# Get the tod register once 0x20000
					$command_string[$cs_index] .= "sr " . $adapter . " 20000 \n";

					# Get the tod register twice 0x20000
					#$command_string[$cs_index] .= "sr " . $adapter . " 20000 \n";
				
					# Get the tod "who does this adapter think is TOD master?" register 0x21040
					$command_string[$cs_index] .= "sr " . $adapter . " 21040 \n";

					# Get the tod general register 0x21030
					$command_string[$cs_index] .= "sr " . $adapter . " 21030 \n";

					# Get the tod master register 0x21000
					$command_string[$cs_index] .= "sr " . $adapter . " 21000 \n";

					# Get the tod backup register 0x21010
					$command_string[$cs_index] .= "sr " . $adapter . " 21010 \n";
				
					# Get the physical id register 0x2B000
					$command_string[$cs_index] .= "sr " . $adapter . " 2B000 \n";
					
					# Get the switch neighbor register 0x23020
					$command_string[$cs_index] .= "sr " . $adapter . " 23020 \n";
				
					$command_count += 9;
				}
			}

			# Get the LPAR names
			for($lpar_id = 1; $lpar_id <= $vport_record->num_lpars(); $lpar_id++)
			{
				$hex_id = sprintf("%x", $lpar_id);

				$vport_record->lpar_names($lpar_id, "");
				$command_string[$cs_index] .= "cd 80 00 00 00 00 01 02 02 $hex_id\n";
				$command_count++;
			}		

	
			# Get the LPAR assignments for each adapter
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 02\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 03\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 06\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 07\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 08\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 09\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 0C\n";
			$command_string[$cs_index] .= "cd 80 00 00 00 00 01 07 15 00 00 00 0D\n";
			$command_count += 8;			

			# Break up the commands into blocks, to scale on large systems
			if($command_count / $commands_per_block >= 1)
			{
				$cs_index++;
				$cs_max++;
				$command_string[$cs_index] = "";
				$command_count = 0;
			}

			$record_count++;
		}
	}
	
	if( $record_count == 0 )
	{
		return;
	}
	
	if( $command_string[$cs_max] eq "" )
	{
		$cs_max--;
	}
		
	$record_count = 0;
	
	for($cs_index = 0; $cs_index <= $cs_max; $cs_index++)
	{
		#print { STDOUT } "$command_string[$cs_index]";

		open(FH, "$fnm_test -s \"$command_string[$cs_index]\" |") or die("Failed to open fnm_test.");

		my $current_adapter = 0;
		my $scom_address = "";
		my $rc_state = "";
		my $command = "";
		my $lpar_map_index = 0;
		my $string = "";
		my $lpar_id = 0;

		while(<FH>)
		{
			chomp;
		
			if($debug)
			{
				print { STDOUT } "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} ".";
				}
	
				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} "\n";
				}
			}	

			if(/VPORT/)
			{
				if(/([0123456789abcdef]{8})/)
				{
					# Grab the vport for this packet. 
					$current_vport = $1;
					#print { STDOUT } "$1 ";
				}
			}

			if(/PAYLOAD HEX/)
			{
				my $count = 0;
				$string = "";
				$lpar_id = 0;
				while(/([0123456789abcdef]{2})/g)
				{
					# Check to see if this vport is IPL_READY
					
					if($count == 4)
					{
						if($1 eq "00")
						{
							$rc_state = "GOOD_RC";
						}
						else
						{
							$rc_state = "BAD_RC";
						} 		
					}
				
					if($count == 7)
					{
						if($1 eq "15")
						{
							$command = "LPAR_ASSIGN";
						}
						elsif($1 eq "02")
						{
							$command = "LPAR_NAME";
						}
						else
						{
							$command = "SCOM";
						}
					}
   	                     	
					if($command eq "LPAR_NAME")
					{	
						if($count == 8)
                	                	{
							$lpar_id = hex($1);
                	                	}

						if($count > 8)
						{
                	                        	$string .= chr(hex($1));
						}
					}

					$count++;
				}
			}

			if($rc_state eq "GOOD_RC")
			{
				if($command eq "SCOM")
				{
					if(/CHIP/)
					{
						if(/([0123456789abcdef]{8})/)
						{
							# Grab the chip id and convert it to adapter number
							$current_adapter = $csp_to_adapter{hex($1)};		
							my $temp = hex($1);			

							#print { STDOUT } "adapter map $1($temp) => $current_adapter \n";
						}
					}
			
					if(/ADDRESS/)
					{
						if(/([0123456789abcdef]{8})/)
						{	
							# Grab the scom address
							$scom_address = $1;
						}	
					}

					if(/DATA/)
					{
						if(/([0123456789abcdef]{8} [0123456789abcdef]{8})/)
						{
				
							if($scom_address eq "00024030")
							{
								$vport_records{$current_vport}->timing($current_adapter, $1);
						
								if(substr($1,0,2) eq "00")
								{
									$vport_records{$current_vport}->timed($current_adapter, "YES");
								}
								else
								{
									$vport_records{$current_vport}->timed($current_adapter, "NO");
								}	
							}
							elsif($scom_address eq "00006050")
							{
								$vport_records{$current_vport}->mp_avail($current_adapter, $1);
								
								if(substr($1,0,2) eq "00")
								{
									$vport_records{$current_vport}->mp($current_adapter, "NO");
								}
								elsif(substr($1,0,2) eq "10")
								{
									$vport_records{$current_vport}->mp($current_adapter, "YES");
								}	
								elsif(substr($1,0,2) eq "20")
								{
									$vport_records{$current_vport}->mp($current_adapter, "FAT");
								}	
							}
							elsif($scom_address eq "00020000")
							{
								if($vport_records{$current_vport}->t_one($current_adapter) eq "-------- --------")
								{
									$vport_records{$current_vport}->t_one($current_adapter, $1);
								}
								else
								{
									$vport_records{$current_vport}->t_two($current_adapter, $1);
								}
							}
							elsif($scom_address eq "00021030")
							{
								$vport_records{$current_vport}->t_gen($current_adapter, $1);
							}
							elsif($scom_address eq "00021040")
							{
								$vport_records{$current_vport}->who_mast($current_adapter, $1);
							}
							elsif($scom_address eq "00021000")
							{
								$vport_records{$current_vport}->t_mast($current_adapter, $1);
							
								my $tod_back = $vport_records{$current_vport}->t_back($current_adapter);
								my $tod_mast = $1;

								if( $tod_back ne "-" )
								{
									if( (substr($tod_mast,0,2) eq "80") &&
									    (substr($tod_back,0,2) eq "00" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "MAS");
									}
									elsif( (substr($tod_mast,0,2) eq "00") &&
                                                        	               (substr($tod_back,0,2) eq "80" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "BAK");
									}
									elsif( (substr($tod_mast,0,2) eq "00") &&
                                                        	               (substr($tod_back,0,2) eq "00" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "SLV");
									}
								}
							}
							elsif($scom_address eq "00021010")
							{
								$vport_records{$current_vport}->t_back($current_adapter, $1);
							
								my $tod_back = $1;
								my $tod_mast = $vport_records{$current_vport}->t_mast($current_adapter);

								if( $tod_mast ne "-" )
								{
									if( (substr($tod_mast,0,2) eq "80") &&
									    (substr($tod_back,0,2) eq "00" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "MAS");
									}
									elsif( (substr($tod_mast,0,2) eq "00") &&
                                        	                               (substr($tod_back,0,2) eq "80" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "BAK");
									}
									elsif( (substr($tod_mast,0,2) eq "00") &&
                                        	                               (substr($tod_back,0,2) eq "00" ) )
									{
										$vport_records{$current_vport}->tod($current_adapter, "SLV");
									}
								}
							}
							elsif($scom_address eq "0002b000")
							{
								$vport_records{$current_vport}->phys_id($current_adapter, $1);
						
								$id = hex(substr($1, 0, 1));					
								$vport_records{$current_vport}->nid($current_adapter, $id);
						
								$id = hex(substr($1, 1, 3));					
								$vport_records{$current_vport}->eid($current_adapter, $id);
							}
							elsif($scom_address eq "00023020")
							{
								$vport_records{$current_vport}->sloc($current_adapter, $1);
					
								$id = hex(substr($1, 11, 3));					
								$vport_records{$current_vport}->nf($current_adapter, $id);
							
								$id = hex(substr($1, 14, 2));					
								$vport_records{$current_vport}->nca($current_adapter, $id);	
								
								$id = hex(substr($1, 16, 1));
								$id = ($id & 0x07);					
								$vport_records{$current_vport}->nch($current_adapter, $id);	
							
								$id = hex(substr($1, 7, 1));
								$id = (($id >> 1) & 0x07);					
								$vport_records{$current_vport}->np($current_adapter, $id);	
							}
						}
					}
				}
				elsif($command eq "LPAR_NAME")
				{               
					$vport_records{$current_vport}->lpar_names($lpar_id, $string);
					$lpar_id = 0;
					$string = 0;
				}
				else
				{
					# Must be a LPAR_ASSIGNMENT command
					if($rc_state eq "GOOD_RC")
					{
						if(/PAYLOAD HEX/)
						{
							#print { STDOUT } "$_ \n";
							$csp = hex(substr($_,41,1));

							#print { STDOUT } "CSP = $csp \n";
						
							$number_of_lpars = hex(substr($_,43,2));
							$offset = 45;						

							#print { STDOUT } "NUMBER_OF_LPARS = $number_of_lpars \n";

							for($count = 0; $count < $number_of_lpars; $count++)
							{
								#Get the current lpar id
								$lpar_id = hex(substr($_,($offset + (2 * $count)), 2));
								#print { STDOUT } "LPAR_ID = $lpar_id \n";
					
								my $lpar_map_ref = $vport_records{$current_vport}->lpar_map;
								#print { STDOUT } "LPAR_MAP_REF: $lpar_map_ref \n"; 
	
								if( exists( $lpar_map_ref->{$lpar_id} ) )
								{
									# We already have a record for this lpar_id
									#print { STDOUT } "Record exists for lpar $lpar_id \n";
								}
								else
								{
									# We need to create a record for this lpar_id
									#print { STDOUT } "Creating record for lpar $lpar_id \n";
	
									my $lpar_record = LparMapRecord->new();
									$lpar_record->lpar_id($lpar_id);
									$lpar_map_ref->{$lpar_id} = $lpar_record;
								}

								#Insert the csp number into the list for this lpar.
								my $csp_numbers_ref = $lpar_map_ref->{$lpar_id}->csp_numbers;
			
								push(@$csp_numbers_ref, $csp);

								$print_lpar_id = $lpar_map_ref->{$lpar_id}->lpar_id;
								#print { STDOUT } "LPAR_RECORD: $print_lpar_id \n"; 
							}
						}
					}
				}
			}
		}
		close(FH);
	
	}	# End of scaling loop
}

sub get_hmc_addresses 
{
	$service_network_timeout = 3;
	
	# set a timer
	eval
	{
		local $SIG{ALRM} = sub 
		{
			printf ("\nERROR: Command timed out while attempting to contact the local hdwr_svr.\n"); 

			# Clear the HMC hash
			%hmc_records = ();
				
			die "alarm clock restart"; 
		};
	
		alarm $service_network_timeout;

	eval
	{
	open(FH, "$fnm_test -s \"qgi\" | ") or die("Failed to open fnm_test.");

	my $hmc_record;

	while(<FH>)
	{
		chomp;
	
		if($debug)
		{	
			print {STDOUT} "$_ \n";
		}
		else
		{	
			$line_count++;
			if($line_count % $lines_per_dot == 0)
			{
				print {STDOUT} "";
				# print {STDOUT} ".";
			}

			if($line_count % ($lines_per_dot * $dots_before_break) == 0)
			{
				print {STDOUT} "";
				# print {STDOUT} "\n";
			}
		}	

		if(/IP LIST/)
		{
			$count = 0;
			my $decimal_dotted = "";
			my $hostname = "";
			my @hostname_array;	
			my $global_vport;
	
			while(/([0123456789abcdef]+)/g)
			{
				$hmc_record = ServiceNetworkHmc->new();

				$global_vport = (hex($1) << 9) && 0xfffffe00;

				$decimal_dotted =  hex(substr($1,0,2)) . "."; 
				$decimal_dotted .= hex(substr($1,2,2)) . ".";
				$decimal_dotted .= hex(substr($1,4,2)) . ".";
				$decimal_dotted .= hex(substr($1,6,2));

				$hostname = gethostbyaddr(inet_aton($decimal_dotted), AF_INET);
				@hostname_array = split(/\./, $hostname);
				$hostname = $hostname_array[0];
				
				$hmc_record->ip_address($1);
				$hmc_record->ip_string($decimal_dotted);
				$hmc_record->hostname($hostname);
				$hmc_record->global_vport($global_vport);

				#print "$1 $decimal_dotted $hostname $global_vport\n";	
				
				$hmc_records{ $hmc_record->ip_address() } = $hmc_record; 

				$count++;
			}
		}
	}
	
	}; # End eval
	alarm 0;

	}; # End eval 2
	alarm 0;

	die if $@ && $@ !~ /alarm clock restart/; #reraise	
			
	#print { STDOUT } "\n";
	close(FH);
}

sub get_hmc_vports
{
 	my $mode = "";	
	$service_network_timeout = 3;

	# Get all of the CSP and BPA vports for each HMC in the system 
	foreach $hmc_record (sort { $a->ip_address() <=> $b->ip_address() } values %hmc_records)
	{
		my $command_string = "";
		
		# Get the remote CSP vports
		$command_string .= "qrc " . $hmc_record->ip_address() . " \n";
		
		# Get the remote BPA vports
		$command_string .= "qrb " . $hmc_record->ip_address() . " \n";

		#print $command_string;
	
		# set a timer
		eval
		{
			local $SIG{ALRM} = sub 
			{
				printf ("\nERROR: Command timed out while attempting to contact the local hdwr_svr.\n"); 
				
				# Empty the hardware lists for this HMC
				$csp_vport_hash_ref = $hmc_record->csp_records; 
				%$csp_vport_hash_ref = ();	
				
				$bpa_vport_hash_ref = $hmc_record->bpa_records; 
				%$bpa_vport_hash_ref = ();	
				
				die "alarm clock restart"; 
			};
	
			alarm $service_network_timeout;

		eval
		{
		open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

		while(<FH>)
		{
			chomp;
	
			if($debug)
			{	
				print {STDOUT} "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} ".";
				}

				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} "\n";
				}
			}	

			if(/HDR->MINOR    :       2a/)
			{
				$mode = "CSP";
			}
			elsif(/HDR->MINOR    :       2d/)
			{
				$mode = "BPA";
			}

			if($mode eq "CSP")
			{

				if(/VPORT LIST/)
				{
					while(/([0123456789abcdef]+)/g)
					{	
						my $csp_record = ServiceNetworkCsp->new();

						$csp_record->vport($1);
						$csp_record->cec_name("------------------------");
						$csp_record->mtms("-----------------------");
						$csp_record->frame_number("------------------");

						$hmc_records{$hmc_record->ip_address()}->csp_records->{$csp_record->vport()} = $csp_record;	
					}
				}
			}
			
			if($mode eq "BPA")
			{
				if(/VPORT LIST/)
				{
					while(/([0123456789abcdef]+)/g)
					{
						my $bpa_record = ServiceNetworkBpa->new();

						$bpa_record->vport($1);
						$bpa_record->mtms("-------------------");
						$bpa_record->frame_number("---------------");

						$hmc_records{$hmc_record->ip_address()}->bpa_records->{$bpa_record->vport()} = $bpa_record;	
					}
				}
			}

		}
		}; # End eval
		alarm 0;

		}; # End eval 2
		alarm 0;

		die if $@ && $@ !~ /alarm clock restart/; #reraise	
	}
}

sub get_vport_info
{
 	my $mode = "";	
	$service_network_timeout = 30;

	# Build a string to query the state of all CECs in the system.
	foreach $hmc_record (sort values %hmc_records)
	{
		my $command_string = "";
		
		$csp_vport_hash_ref = $hmc_record->csp_records; 
		$bpa_vport_hash_ref = $hmc_record->bpa_records; 

		foreach $csp (sort values %$csp_vport_hash_ref)
		{
			$command_string .= "sv " . $csp->vport() . "\n"; 
			$command_string .= "cn\n"; 
			$command_string .= "cm\n"; 
			$command_string .= "cgf\n"; 

			#printf "%s\n", $csp->vport();
		}
		
		foreach $bpa (sort values %$bpa_vport_hash_ref)
		{
			$command_string .= "sv " . $bpa->vport() . "\n"; 
			$command_string .= "bgm\n"; 
			$command_string .= "bgf\n"; 

			#printf "%s\n", $bpa->vport();
		}
	
		#print $command_string;
	
		# set a timer
		eval
		{
			local $SIG{ALRM} = sub 
			{
				printf ("\nERROR: Command timed out while attempting to contact HMC %s.\n", $hmc_record->ip_string()); 
				
				# Empty the hardware lists for this HMC
				%$csp_vport_hash_ref = ();
				%$bpa_vport_hash_ref = ();
				die "alarm clock restart"; 
			};
	
			alarm $service_network_timeout;

		eval
		{
		open(FH, "$fnm_test -s \"$command_string\" |") or die("Failed to open fnm_test.");

		while(<FH>)
		{
			chomp;
	
			if($debug)
			{	
				print {STDOUT} "$_ \n";
			}
			else
			{	
				$line_count++;
				if($line_count % $lines_per_dot == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} ".";
				}

				if($line_count % ($lines_per_dot * $dots_before_break) == 0)
				{
					print {STDOUT} "";
					# print {STDOUT} "\n";
				}
			}	

			if(/HDR->MINOR    :       58/)
			{
				$mode = "CSP";
			}
			elsif(/HDR->MINOR    :       55/)
			{
				$mode = "BPA";
			}

			
			if(/VPORT/)
			{
				if(/([0123456789abcdef]{8})/)
				{
					# Grab the vport for this packet. 
					$current_vport = $1;
				}
			}

			if($mode eq "CSP")
			{
				my $string = "";
				my $state = "NONE";


				if(/PAYLOAD HEX/)
				{
					my $count = 0;
					my $last = 0;

					while(/([0123456789abcdef]{2})/g)
					{
						# Check to see if this vport is IPL_READY
					
						if($count == 7)
						{
							if($1 eq "02")
							{
								if($last eq "01")
								{
									$state = "CEC_NAME";
								}
								else
								{
									$state = "FRAME";
								}
							}
							elsif($1 eq "03")
							{
								$state = "MTMS";
							}
						}
					
						if( ( $state eq "CEC_NAME" ) || 
				  		    ( $state eq "MTMS" ) ) 
						{
							if($count >= 8)
							{
								$string .= chr(hex($1));
							}
						}

						if( $state eq "FRAME")
						{
							if($count >= 8)
							{
								$string .= $1;
							}
						}

						$count++;
						$last = $1;
					}
				}

				if( $state eq "CEC_NAME" )
				{
					# Save the CEC_NAME string.
					$csp_vport_hash_ref->{$current_vport}->cec_name($string);
				}
				
				if( $state eq "MTMS" )
				{
					# Save the CEC_MTMS string.
					$csp_vport_hash_ref->{$current_vport}->mtms($string);
				}
				if( $state eq "FRAME" )
				{
					$csp_vport_hash_ref->{$current_vport}->frame_number((hex(substr($string, 0, 4))));	
				}

			}
			
			if($mode eq "BPA")
			{
				# There is no state information in BPA response packet.
				# Guess response type based on payload length. (ugly)

				$string = "";
				$ascii = "";

				if(/PAYLOAD HEX/)
				{
					my $count = 0;
					my $last = 0;

					while(/([0123456789abcdef]{2})/g)
					{
						if($count >= 2)
						{
							$string .= $1;
							$ascii .= chr(hex($1));
						}

						$count++;
					}	
				
					if($count > 4)
					{
						# Assume this is the MTMS
						# Save the MTMS string.
						$bpa_vport_hash_ref->{$current_vport}->mtms(substr($ascii,0,8) 
							. " " . substr($ascii,8,7));
					}
					else
					{
						# Assume this is the frame number
						$bpa_vport_hash_ref->{$current_vport}->frame_number((hex(substr($string, 0, 4))));	
					}
				}
			}
		}
		}; # End eval
		alarm 0;

		}; # End eval 2
		alarm 0;

		die if $@ && $@ !~ /alarm clock restart/; #reraise	
	}
}
